//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function [sr]=%CLquat_size(q)

// Authors
// CNES - DCT/SB
//
// LAST UPDATE
// 02/05/2007
//

// Declarations:


// Code:

[lir cor]=size(q.r);
[lii coi]=size(q.i);
if (lir~=1 | lii~=3 | coi~=cor) then
  CL__error("badly defined quaternion, check dimensions");
  sr=[];
else
  sr=coi;
end

endfunction
